/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.ast.rewrite;

import org2.eclipse.php.internal.core.ast.rewrite.RewriteEvent;

public class NodeRewriteEvent
extends RewriteEvent {
    private Object originalValue;
    private Object newValue;

    public NodeRewriteEvent(Object originalValue, Object newValue) {
        this.originalValue = originalValue;
        this.newValue = newValue;
    }

    @Override
    public Object getNewValue() {
        return this.newValue;
    }

    @Override
    public Object getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public int getChangeKind() {
        if (this.originalValue == this.newValue) {
            return 0;
        }
        if (this.originalValue == null) {
            return 1;
        }
        if (this.newValue == null) {
            return 2;
        }
        if (this.originalValue.equals(this.newValue)) {
            return 0;
        }
        return 4;
    }

    @Override
    public boolean isListRewrite() {
        return false;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @Override
    public RewriteEvent[] getChildren() {
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        switch (this.getChangeKind()) {
            case 1: {
                buf.append(" [inserted: ");
                buf.append(this.getNewValue());
                buf.append(']');
                break;
            }
            case 4: {
                buf.append(" [replaced: ");
                buf.append(this.getOriginalValue());
                buf.append(" -> ");
                buf.append(this.getNewValue());
                buf.append(']');
                break;
            }
            case 2: {
                buf.append(" [removed: ");
                buf.append(this.getOriginalValue());
                buf.append(']');
                break;
            }
            default: {
                buf.append(" [unchanged]");
            }
        }
        return buf.toString();
    }
}

